-- Diese Tabelle für DB-Logmessages wird nicht mehr gebraucht. Jetzt über Umweg von CSV-Dateien in Tabelle "tlog.dblog".
DROP TABLE IF EXISTS TSystem.Log;


-- LogFormat
-- Eingangsparameter:
    -- msg TEXT - Message-Text
    -- linebreaks BOOLEAN - Message-Info bilden mit Zeilenumbruche
    -- VARIADIC arr_msg_txt VARCHAR[] - Message-Info als Array
CREATE OR REPLACE FUNCTION TSystem.LogFormat(IN msg TEXT, IN linebreaks BOOLEAN, VARIADIC arr_msg_txt VARCHAR[] DEFAULT NULL) RETURNS TEXT AS $$
  DECLARE msg_txt TEXT;
  BEGIN
    msg_txt:= format('%s', arr_msg_txt);    -- Text zusammenbauen
    -- ungewünschte Zeichen abschneiden
    msg_txt:= TRIM(leading '{' FROM msg_txt);
    msg_txt:= TRIM(trailing '}' FROM msg_txt);
    msg_txt:= REPLACE(msg_txt, '= ","', '= ');
    msg_txt:= REPLACE(msg_txt, '=","', '=');
    msg_txt:= REPLACE(msg_txt, '",', '');
    IF linebreaks THEN               -- Zeilenunbruche erstellen
        msg_txt:= REPLACE(msg_txt, '","', E'\n');
        msg_txt:= REPLACE(msg_txt, ',"' , E'\n');
    END IF;
    msg_txt:= REPLACE(msg_txt, '"', '');
    IF linebreaks THEN
        msg_txt:= msg || E'\n' || msg_txt;
    ELSE
        msg_txt:= msg || '   ' || msg_txt;
    END IF;

    RETURN msg_txt;
  END $$ LANGUAGE plpgsql;
--
CREATE OR REPLACE FUNCTION TSystem.LogFormat(IN msg TEXT, IN linebreaks BOOLEAN, IN deprecated integer, IN msg_txt text) RETURNS TEXT AS $$
  BEGIN
    RETURN TSystem.LogFormat(msg, linebreaks, msg_txt::varchar);
  END $$ LANGUAGE plpgsql;
--

-- NOTE AXS: Diese Funktionssignatur wird aktuell nicht verwendet, daher auskommentiert.
DROP FUNCTION IF EXISTS tsystem.logformat(text, boolean, json);
-- -- LogText-Formatierung, wenn Record oder Teil von Record gespeichert soll, Record ist als JSON Eingangsparameter
-- CREATE OR REPLACE FUNCTION TSystem.LogFormat(IN msg TEXT, IN linebreaks BOOLEAN, IN js JSON) RETURNS TEXT AS $$
--   DECLARE msg_txt TEXT:= '';
--           rec RECORD;
--   BEGIN
--     FOR rec IN SELECT * FROM json_each(js) LOOP
--         IF NOT linebreaks THEN
--             -- msg_txt:= msg_txt || '"' || rec.key::VARCHAR || '" = ' || rec.value::VARCHAR || ',';  -- TODO JSON-Variante
--             msg_txt:= msg_txt || rec.key::VARCHAR || ' = ' || rec.value::VARCHAR || ', ';
--         ELSE
--             msg_txt:= msg_txt || rec.key::VARCHAR || ' = ' || rec.value::VARCHAR;
--             msg_txt:= msg_txt ||  E'\n';
--         END IF;
--     END LOOP;

--     msg_txt := TRIM(msg_txt);

--     IF NOT linebreaks THEN
--         -- msg_txt:= msg || '   {' || SUBSTRING(msg_txt from 1 for char_length(msg_txt) - 1) || '}';  -- TODO JSON-Variante
--         msg_txt:= msg || '   ' || SUBSTRING(msg_txt from 1 for char_length(msg_txt) - 1);
--     ELSE
--         msg_txt:= msg || E'\n' || msg_txt;
--     END IF;

--     RETURN msg_txt;
--   END $$ LANGUAGE plpgsql;
-- --

-- Initialisierung von DB-Debuglog und Tabellenlog. Von Delphi im OnConnect aufgerufen.
CREATE OR REPLACE FUNCTION TSystem.Log_Init() RETURNS VOID AS $$
  DECLARE
      _level INTEGER;
  BEGIN
    -- Loglevel der Session setzen. Nach Nutzereinstellung, wenn nicht vorhanden dann Systemdefault.
    _level := TSystem.Log_Get_LogLevel( TSystem.current_user() );

    PERFORM SessionVar__set_integer( _suffix => 'sessions_loglevel', _value => _level::integer, _as_tx_var => false );

    RETURN;
  END $$ LANGUAGE plpgsql;
--

-- Aktuelles Loglevel für einen Benutzer ermitteln ( Nutzerlevel abfragen, wenn nicht gesetzt auf System-Loglevel zurückgehen)
CREATE OR REPLACE FUNCTION TSystem.Log_Get_LogLevel(IN _user VARCHAR DEFAULT '') RETURNS INTEGER AS $$
  DECLARE
      currLevel INTEGER;
      my_s_vari VARCHAR(70);
      my_s_inha VARCHAR;
  BEGIN
      IF _user = '' THEN
          my_s_vari:= 'SysLogLevel';
      ELSE
          IF Settings__GetText( vari => 'UserLogLevel_' || TRIM( TSystem.current_user() ), defvalue => null::VARCHAR ) IS NOT NULL THEN
              my_s_vari:= 'UserLogLevel_' || TRIM( TSystem.current_user() );
          ELSE
              my_s_vari:= 'SysLogLevel';
          END IF;
      END IF;
      my_s_inha :=  coalesce(
                        nullif( Settings__GetText( vari => my_s_vari ), '' )
                      , enum_first( null::TLOG.DBLOG_LOGLEVEL )::VARCHAR
                    )
      ;
      currLevel :=  array_position( enum_array, my_s_inha::TLOG.DBLOG_LOGLEVEL ) - 1
                    FROM enum_range( null::TLOG.DBLOG_LOGLEVEL ) AS enum_array
      ;

      RETURN currLevel;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Loglevel für einen Benutzer setzen
CREATE OR REPLACE FUNCTION TSystem.Log_Set_LogLevel(IN _user VARCHAR DEFAULT '', currLevel INTEGER DEFAULT 0) RETURNS VOID AS $$
  DECLARE
      my_s_vari VARCHAR(70);
      my_s_inha VARCHAR;
      enum_array VARCHAR[];
  BEGIN
      IF _user = '' THEN
          my_s_vari:= 'SysLogLevel';
      ELSE
          my_s_vari:= 'UserLogLevel_' || TRIM( UPPER( TSystem.current_user() ) );
      END IF;

      enum_array := enum_range( null::TLOG.DBLOG_LOGLEVEL );
      my_s_inha  := enum_array[ currLevel + 1 ];

      PERFORM TSystem.Settings__Set(my_s_vari, my_s_inha);
      PERFORM SessionVar__set_integer( _suffix => 'sessions_loglevel', _value => currLevel, _as_tx_var => false );

      RETURN;
  END $$ LANGUAGE plpgsql;
--

-- Funktionsname der aktuell laufenden Funktion ermitteln
-- https://stackoverflow.com/questions/12611596/getting-name-of-the-current-function-inside-of-the-function-with-plpgsql
CREATE OR REPLACE FUNCTION TSystem.curr_func_name__get() RETURNS varchar AS $$
  DECLARE
      stack     varchar;
      funcname  varchar;
  BEGIN
      -- Nur einen Stack aufbauen, wenn das Loglevel "pllDebug" oder größer ist.
      IF ( SELECT array_position( enum_array, 'pllDebug'::TLOG.DBLOG_LOGLEVEL ) - 1 FROM enum_range( null::TLOG.DBLOG_LOGLEVEL ) AS enum_array ) <= TSystem.SessionVar__get_integer( _suffix => 'sessions_loglevel', _default => 2 )  THEN
          GET DIAGNOSTICS stack = PG_CONTEXT; -- TODO AXS: Ab PG16 gibt es "GET DIAGNOSTICS var = PG_ROUTINE_OID;". Vielleicht hierüber umsetzen. Problem: Kann nicht in Funktion gepackt werden, dann käme oid dieser Funktion zurück. Aktuelles Verfahren kann keine Schemas.
          funcname := substring( substring( stack from 'function (.*)' ) from 'function (.*?) line' );  -- verschachteltes substring um 2. Funktionsname im Stack zu ermittln
          funcname := funcname::regprocedure::varchar;
      END IF;

      RETURN funcname;
  END; $$ LANGUAGE plpgsql;
--

-- Basisfunktion um Logeintrag zu erstellen. Alle Ableitungen gehen hierauf zurück.
SELECT tsystem.function__drop_by_regex( 'LogMessage', 'tsystem', _commit => true, _cascade => true );
CREATE OR REPLACE FUNCTION TSystem.LogMessage(
        loglevel  tlog.dblog_loglevel                           -- Filterstufe für das Logging, von wichtig bzw. prägnant zu unwichtig bzw. ausführlich
      , func_name varchar                                       -- Name der funktion, welche das Logging ruft
      , ctx       varchar                                       -- Kontext
      , msg       varchar                                       -- Meldung
      , parent_id bigint                DEFAULT NULL            -- übergeordneter Eintrag
      , logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'  -- Art bzw. Zweck
      , logsource tlog.dblog_logsource  DEFAULT 'plsDB'         -- Quelle
    ) RETURNS bigint
  AS $$

    -- Erstmal alle Meldungen schreiben. Filterung passiert bei Anzeige.
    SELECT tlog.dblog__log_line__create(
                a_logtype   => logtype
              , a_loglevel  => loglevel
              , a_logsource => logsource
              , a_parent_id => parent_id
              , a_func_name => func_name
              , a_ctx       => ctx
              , a_msg       => msg
            )

  $$ LANGUAGE sql;
--

-- Überladene Logfunktionen nach Loglevel
    --
    SELECT tsystem.function__drop_by_regex( 'LogFatalError', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogFatalError(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  TSystem.LogMessage(
                      loglevel  => 'pllFatalError'
                    , func_name => func_name
                    , ctx       => context
                    , msg       => message
                    , parent_id => parent_id
                    , logtype   => logtype
                    , logsource => logsource
                  )

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogFatalError(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogFatalError(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogError', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogError(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  TSystem.LogMessage(
                      loglevel  => 'pllError'
                    , func_name => func_name
                    , ctx       => context
                    , msg       => message
                    , parent_id => parent_id
                    , logtype   => logtype
                    , logsource => logsource
                  )

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogError(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogError(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogWarning', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogWarning(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  TSystem.LogMessage(
                      loglevel  => 'pllWarning'
                    , func_name => func_name
                    , ctx       => context
                    , msg       => message
                    , parent_id => parent_id
                    , logtype   => logtype
                    , logsource => logsource
                  )

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogWarning(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogWarning(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogInfo', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogInfo(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  TSystem.LogMessage(
                      loglevel  => 'pllInfo'
                    , func_name => func_name
                    , ctx       => context
                    , msg       => message
                    , parent_id => parent_id
                    , logtype   => logtype
                    , logsource => logsource
                  )

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogInfo(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogInfo(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogDebug', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogDebug(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  CASE
                      -- Aktuelles LogLevel ist 'pllDebug' oder größer, ...
                      WHEN ( SELECT array_position( enum_array, 'pllDebug'::TLOG.DBLOG_LOGLEVEL ) - 1 FROM enum_range( null::TLOG.DBLOG_LOGLEVEL ) AS enum_array ) <= TSystem.SessionVar__get_integer( _suffix => 'sessions_loglevel', _default => 2 ) THEN
                          -- ... dann Logeintrag schreiben.
                          TSystem.LogMessage(
                              loglevel  => 'pllDebug'
                            , func_name => func_name
                            , ctx       => context
                            , msg       => message
                            , parent_id => parent_id
                            , logtype   => logtype
                            , logsource => logsource
                          )
                      -- Anonsten, aktuelles LogLevel ist kleiner als 'pllDebug', ...
                      ELSE
                          -- ... dann nichts machen.
                          NULL
                  END

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogDebug(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogDebug(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogDebugVerbose', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogDebugVerbose(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  CASE
                      -- Aktuelles LogLevel ist 'pllDebug' oder größer, ...
                      WHEN ( SELECT array_position( enum_array, 'pllDebug'::TLOG.DBLOG_LOGLEVEL ) - 1 FROM enum_range( null::TLOG.DBLOG_LOGLEVEL ) AS enum_array ) <= TSystem.SessionVar__get_integer( _suffix => 'sessions_loglevel', _default => 2 ) THEN
                          -- ... dann Logeintrag schreiben.
                          TSystem.LogMessage(
                              loglevel  => 'pllDebugVerbose'
                            , func_name => func_name
                            , ctx       => context
                            , msg       => message
                            , parent_id => parent_id
                            , logtype   => logtype
                            , logsource => logsource
                          )
                      -- Anonsten, aktuelles LogLevel ist kleiner als 'pllDebug', ...
                      ELSE
                          -- ... dann nichts machen.
                          NULL
                  END

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogDebugVerbose(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogDebugVerbose(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogAlways', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogAlways(
      IN   message   varchar
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN logtype   tlog.dblog_logtype    DEFAULT 'pltDebugging'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  TSystem.LogMessage(
                      loglevel  => 'pllAlways'
                    , func_name => func_name
                    , ctx       => context
                    , msg       => message
                    , parent_id => parent_id
                    , logtype   => logtype
                    , logsource => logsource
                  )

      $$ LANGUAGE sql;
    --

    -- TODO AXS: Die folgende Funktionssignatur löschen, sobald alle alten Aufrufe im Delphi verschwunden sind.
    CREATE OR REPLACE FUNCTION TSystem.LogAlways(source VARCHAR, message TEXT, category INTEGER DEFAULT 0, context TEXT DEFAULT NULL) RETURNS VOID AS $$
      BEGIN
        PERFORM TSystem.LogAlways(
                    message   => message
                  , func_name => source
                  , context   => context
                )
        ;

        RETURN;
      END $$ LANGUAGE plpgsql;
    --

    --
    SELECT tsystem.function__drop_by_regex( 'LogHTTPRequest', 'TSystem', _commit => true );
    CREATE OR REPLACE FUNCTION TSystem.LogHTTPRequest(
      IN   request   http_request
      , IN response  http_response
      , IN loopcnt   integer
      , IN context   varchar               DEFAULT TSystem.SessionVar__get_varchar( _prefix => 'Log', _suffix => 'Context' )
      , IN func_name varchar               DEFAULT TSystem.curr_func_name__get()
      , IN parent_id bigint                DEFAULT NULL
      , IN loglevel  tlog.dblog_loglevel   DEFAULT 'pllDebug'
      , IN logsource tlog.dblog_logsource  DEFAULT 'plsDB'
      ) RETURNS bigint
      AS $$

          SELECT  TSystem.LogMessage(
                      loglevel   => loglevel
                    , func_name  => func_name
                    , ctx        => context
                    , msg        => jsonb_build_object(
                                        'request'
                                      , jsonb_build_object(
                                            'method'
                                          , request.method
                                          , 'uri'
                                          , request.uri
                                        )
                                      , 'response'
                                      , jsonb_build_object(
                                            'status'
                                          , response.status
                                          , 'content_type'
                                          , response.content_type
                                          , 'content'
                                          , response.content
                                        )
                                      , 'loop'
                                      ,  loopcnt
                                    )::jsonb::varchar
                    , parent_id  => parent_id
                    , logtype    => 'pltHttpRequest'
                    , logsource => logsource
                  )

      $$ LANGUAGE sql;
    --
--

--
CREATE OR REPLACE FUNCTION tsystem.selects_count__control(
    IN _tabname      varchar,
    IN _select_q     text,
    IN _select_z     text
  ) RETURNS void AS $$
  DECLARE _count_q   integer;   --- Quelle
          _count_z   integer;   --- Ziel
  BEGIN

    EXECUTE _select_q INTO _count_q;
    EXECUTE _select_z INTO _count_z;

    RAISE NOTICE '_select_z = %', _select_z;
    RAISE NOTICE '_count1 = %, _count2 = %', _count_q, _count_z;

    IF  _count_q <> _count_z THEN
        PERFORM PRODAT_MESSAGE( format( lang_text( 29789 ), _tabname, _count_q, _count_z ), 'Information');
    END IF;

 END $$ LANGUAGE plpgsql;
--